// Footer Navigation
// ------------
// Description: The footer navigation data for the website.
export interface Logo {
	src: string
	alt: string
	text: string
}

export interface FooterAbout {
	title: string
	aboutText: string
	logo: Logo
}

export interface SubCategory {
	subCategory: string
	subCategoryLink: string
}

export interface FooterColumn {
	category: string
	subCategories: SubCategory[]
}

export interface SubFooter {
	copywriteText: string
}

export interface FooterData {
	footerAbout: FooterAbout
	footerColumns: FooterColumn[]
	subFooter: SubFooter
}

export const footerNavigationData: FooterData = {
	footerAbout: {
		title: 'Omniblazz',
		aboutText: 'Platform SaaS Omnichannel Chat + Whatsapp Blast berbasis AI yang menyatukan chat & marketplace dalam satu inbox untuk mempercepat CS dan penjualan. Tingkatkan efisiensi tim Anda dengan fitur otomatisasi cerdas dan analitik mendalam dari Omniblazz.',
    logo: {
			src: '/logo-omniblazz.png',
			alt: 'Logo Omniblazz',
			text: ''
		}
	},
	footerColumns: [
		{
			category: 'Menu',
			subCategories: [
        {
					subCategory: 'Beranda',
					subCategoryLink: '/'
				},
        {
					subCategory: 'Harga',
					subCategoryLink: '/harga/'
				},
				{
					subCategory: 'Fitur',
					subCategoryLink: '/fitur/'
				},
        {
					subCategory: 'Kontak',
					subCategoryLink: '/kontak/'
				}
			]
		},
		{
			category: 'Informasi',
			subCategories: [
				{
					subCategory: 'Tentang Kami',
					subCategoryLink: '/tentang-kami/'
				},
				{
					subCategory: 'Blog',
					subCategoryLink: '/blog/'
				},
        {
					subCategory: 'FAQ',
					subCategoryLink: '/faq/'
				}
			]
		},
		{
			category: 'Dokumen',
			subCategories: [
				{
					subCategory: 'Syarat dan Ketentuan',
					subCategoryLink: '/syarat-dan-ketentuan/'
				},
        {
					subCategory: 'Kebijakan Privasi',
					subCategoryLink: '/kebijakan-privasi/'
				},
        {
					subCategory: 'Penghapusan Data',
					subCategoryLink: '/penghapusan-data/'
				}
			]
		}
	],
	subFooter: {
		copywriteText: '© 2025 - Omniblazz - PT Mitra Hwtek Indonesia.'
	}
}
